package com.xunyi.beast.propagation.shunt;


import com.xunyi.beast.propagation.PropagationAutoConfiguration;
import com.xunyi.beast.propagation.context.CurrentContext;
import com.xunyi.beast.propagation.shunt.propagation.CurrentShuntContext;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value = "micro.shunt.enabled", matchIfMissing = true)
@ConditionalOnBean(CurrentContext.class)
@AutoConfigureAfter(PropagationAutoConfiguration.class)
@EnableConfigurationProperties(ShuntProperties.class)
public class ShuntAutoConfiguration {


    @Bean
    @ConditionalOnMissingBean
    public CurrentShuntContext currentShuntContext(CurrentContext currentContext) {
        return new CurrentShuntContext(currentContext);
    }

    @Bean
    @ConditionalOnMissingBean
    public Shunt shunt(
//            @Value("${spring.application.name:default}") String serviceName,
            CurrentShuntContext currentShuntContext
    ) {
        Shunt.ShuntBuilder builder = Shunt.builder()
                .currentShuntContext(currentShuntContext);
        return builder.build();

    }
}
