package com.xunyi.beast.propagation.shunt.group;

import com.netflix.loadbalancer.AbstractServerPredicate;
import com.netflix.loadbalancer.PredicateKey;
import com.netflix.loadbalancer.Server;
import org.checkerframework.checker.nullness.qual.Nullable;

import java.util.List;

/**
 * 异步
 */
public abstract class PriorityPredicatePredicate extends AbstractServerPredicate {

    private int minimalFilteredServers = 1;

    @Override
    public boolean apply(@Nullable PredicateKey predicateKey) {
        throw new UnsupportedOperationException();
    }

    public abstract List<AbstractServerPredicate> getPredicates();

    @Override
    public List<Server> getEligibleServers(List<Server> servers, Object loadBalancerKey) {
        List<AbstractServerPredicate> predicates = getPredicates();

        var iter = predicates.iterator();
        AbstractServerPredicate predicate = iter.next();
        List<Server> result = predicate.getEligibleServers(servers, loadBalancerKey);
        while (!(result.size() >= minimalFilteredServers) && iter.hasNext()) {
            predicate = iter.next();
            result = predicate.getEligibleServers(servers, loadBalancerKey);
        }
        return result;
    }
}
