/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.propagation.shunt.group;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractServerPredicate;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.PredicateBasedRule;
import com.netflix.loadbalancer.Server;
import com.xunyi.beast.propagation.shunt.Shunt;
import com.xunyi.beast.propagation.shunt.group.EmptyServerGroupPredicate;
import com.xunyi.beast.propagation.shunt.group.PriorityPredicatePredicate;
import com.xunyi.beast.propagation.shunt.group.ServerGroupPredicate;
import com.xunyi.beast.propagation.shunt.group.ServerGroupShunting;
import com.xunyi.beast.propagation.shunt.propagation.ShuntContext;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

public class ShuntingContextRule
extends PredicateBasedRule {
    private Shunt shunt;
    private PriorityPredicatePredicate priorityPredicatePredicate = this.createPredicate();

    public void initWithNiwsConfig(IClientConfig clientConfig) {
        super.initWithNiwsConfig(clientConfig);
        SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext((Object)((Object)this));
    }

    public PriorityPredicatePredicate createPredicate() {
        return new PriorityPredicatePredicate(){

            @Override
            public List<AbstractServerPredicate> getPredicates() {
                return ShuntingContextRule.this.createShuntingPredicates();
            }
        };
    }

    public List<AbstractServerPredicate> createShuntingPredicates() {
        ShuntContext context = this.shunt.currentShuntContext().get();
        if (context == null) {
            return Lists.newArrayList((Object[])new AbstractServerPredicate[]{AbstractServerPredicate.alwaysTrue()});
        }
        List<String> sequence = context.sequences();
        List<AbstractServerPredicate> predicates = sequence.stream().map(ServerGroupShunting::new).map(ServerGroupPredicate::new).collect(Collectors.toList());
        predicates.add(new ServerGroupPredicate(new ServerGroupShunting("standard")));
        predicates.add(new EmptyServerGroupPredicate());
        return predicates;
    }

    public Server choose(Object key) {
        ILoadBalancer lb = this.getLoadBalancer();
        Optional server = this.getPredicate().chooseRoundRobinAfterFiltering(lb.getAllServers(), key);
        if (server.isPresent()) {
            return (Server)server.get();
        }
        return null;
    }

    public AbstractServerPredicate getPredicate() {
        return this.priorityPredicatePredicate;
    }

    @Autowired
    public void setShunt(Shunt shunt) {
        this.shunt = shunt;
    }
}

