package com.xunyi.beast.payment.notify;


import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;

@Slf4j
public class HttpNotifier implements Notifier {


    private final HttpClient client;

    public HttpNotifier() {
        this.client = HttpClientBuilder.create().build();
    }

    @Override
    public NotifyReturn call(URI target, NotifyCarry notify) throws IOException {

        Map<String, String> params = notify.post();



        List<NameValuePair> pairs = Lists.newArrayList();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            pairs.add(new BasicNameValuePair(key, value));
        }

        EntityBuilder entityBuilder = EntityBuilder.create()
                .setParameters(pairs);


        HttpPost httpPost = new HttpPost(target);
        RequestConfig requestConfig = RequestConfig.custom()
                .setConnectTimeout(6 * 1000)
                .setSocketTimeout(8 * 1000)
                .build();
        httpPost.setConfig(requestConfig);
        httpPost.setEntity(entityBuilder.build());


        NotifyReturn result = NotifyReturn.newOf(notify);

        HttpResponse response = this.client.execute(httpPost);
        String responseString = EntityUtils.toString(response.getEntity());
        boolean success = "success".equals(responseString);

        if (success) {
            result.setResult(NotifyResult.SUCCESS);
        } else {
            result.setResult(NotifyResult.FAILURE);
            result.setException("response != 'success'， value '" + responseString + "'");
            log.warn("response != 'success' , notifyId:{} target: {}  response:{}", notify.id(), target, responseString);
        }

        return result;
    }
}
