/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.payment.notify;

import com.google.common.collect.Lists;
import com.xunyi.beast.payment.notify.Notifier;
import com.xunyi.beast.payment.notify.NotifyCarry;
import com.xunyi.beast.payment.notify.NotifyResult;
import com.xunyi.beast.payment.notify.NotifyReturn;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpNotifier
implements Notifier {
    private static final Logger log = LoggerFactory.getLogger(HttpNotifier.class);
    private final HttpClient client = HttpClientBuilder.create().build();

    @Override
    public NotifyReturn call(URI target, NotifyCarry notify) throws IOException {
        Map<String, String> params = notify.post();
        ArrayList pairs = Lists.newArrayList();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            pairs.add(new BasicNameValuePair(key, value));
        }
        EntityBuilder entityBuilder = EntityBuilder.create().setParameters((List)pairs);
        HttpPost httpPost = new HttpPost(target);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(6000).setSocketTimeout(8000).build();
        httpPost.setConfig(requestConfig);
        httpPost.setEntity(entityBuilder.build());
        NotifyReturn result = NotifyReturn.newOf(notify);
        HttpResponse response = this.client.execute((HttpUriRequest)httpPost);
        String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
        boolean success = "success".equals(responseString);
        if (success) {
            result.setResult(NotifyResult.SUCCESS);
        } else {
            result.setResult(NotifyResult.FAILURE);
            result.setException("response != 'success'\uff0c value '" + responseString + "'");
            log.warn("response != 'success' , notifyId:{} target: {}  response:{}", new Object[]{notify.id(), target, responseString});
        }
        return result;
    }
}

