/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.payment.notify;

import com.xunyi.beast.payment.notify.HttpNotifier;
import com.xunyi.beast.payment.notify.Notifier;
import com.xunyi.beast.payment.notify.NotifyCarry;
import com.xunyi.beast.payment.notify.NotifyReturn;
import java.io.IOException;
import java.net.URI;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.web.util.UriComponentsBuilder;

public class CompatibleNotifier
implements Notifier {
    private HttpNotifier httpNotifier;
    private LoadBalancerClient loadBalancerClient;

    public CompatibleNotifier(HttpNotifier httpNotifier, LoadBalancerClient loadBalancerClient) {
        this.httpNotifier = httpNotifier;
        this.loadBalancerClient = loadBalancerClient;
    }

    @Override
    public NotifyReturn call(URI target, NotifyCarry notify) throws IOException {
        String scheme = (target = this.filter(target, notify)).getScheme();
        if ("http".equals(scheme) || "https".equals(scheme)) {
            return this.httpNotifier.call(target, notify);
        }
        throw new IllegalArgumentException("target invalid:" + target);
    }

    private URI filter(URI target, NotifyCarry notify) {
        String scheme = target.getScheme();
        if ("lb".equals(scheme)) {
            ServiceInstance instance = this.choose(target.getHost());
            if (instance == null) {
                throw new IllegalStateException("unable to find instance for " + target.getHost());
            }
            String overrideScheme = instance.isSecure() ? "https" : "http";
            return UriComponentsBuilder.fromUri((URI)target).scheme(overrideScheme).host(instance.getHost()).port(instance.getPort()).build().toUri();
        }
        return target;
    }

    protected ServiceInstance choose(String host) {
        return this.loadBalancerClient.choose(host);
    }
}

