package com.xunyi.beast.payment.core.convert;


import com.xunyi.beast.payment.core.PaymentSymbol;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.Nullable;

import java.util.ArrayList;
import java.util.List;

public class PaymentConverters {

    private PaymentConverters() {

    }

    public static List<?> getConvertersToRegister() {
        List<Object> converts = new ArrayList<>();
        converts.add(StringToPaymentSymbolConvert.INSTANCE);
        converts.add(PaymentSymbolToStringConvert.INSTANCE);
        return converts;
    }

    static enum StringToPaymentSymbolConvert implements Converter<String, PaymentSymbol> {
        INSTANCE;

        @Override
        public PaymentSymbol convert(@Nullable String source) {
            return source == null ? null : new PaymentSymbol(source);
        }
    }

    static enum PaymentSymbolToStringConvert implements Converter<PaymentSymbol, String> {
        INSTANCE;

        @Override
        public String convert(@Nullable PaymentSymbol source) {
            return source == null ? null : source.toString();
        }
    }
}
