package com.xunyi.beast.payment.core;

import lombok.Getter;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

import java.util.List;
import java.util.Optional;

@Getter @Setter
@Slf4j
public class App {

    private String appId;

    //路由
    private List<PayRoute> routes;

    //TODO 临时实现  应该封装成 webhook
    //交易通知目标
    private String tradeNotifyTarget;

    private String orderNotifyTarget;


    public String lookup(PayMethod payMethod, String payMode) {
        Optional<PayRoute> routeOptional = routes.stream().filter(route -> {
            return route.allow(payMethod, payMode);
        }).findFirst();
        if (routeOptional.isEmpty()) {
            return null;
        }
        PayRoute route = routeOptional.get();
        return route.getChannelId();
    }
}
