/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.payment.core;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import com.xunyi.beast.payment.core.PayMethod;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class PaymentSymbol
implements Serializable {
    protected static final String PART_DIVIDER_TOKEN = ":";
    protected static final String WILDCARD_TOKEN = "*";
    protected static final String SUBPART_DIVIDER_TOKEN = ",";
    private PayMethod method;
    private Set<String> modes;

    public PaymentSymbol(String symbol) {
        this.parseSymbol(symbol);
    }

    public PaymentSymbol(PayMethod method, String mode) {
        this.method = method;
        this.modes = Sets.newHashSet((Object[])new String[]{mode});
    }

    private void parseSymbol(String symbolString) {
        if (StringUtils.isEmpty((CharSequence)symbolString)) {
            throw new IllegalArgumentException("symbol string cannot be empty");
        }
        Iterable parts = Splitter.on((String)PART_DIVIDER_TOKEN).split((CharSequence)symbolString);
        Iterator partsIter = parts.iterator();
        this.method = PayMethod.valueOf((String)partsIter.next());
        this.modes = Sets.newHashSet((Object[])((String)partsIter.next()).split(SUBPART_DIVIDER_TOKEN));
    }

    public boolean implies(PaymentSymbol symbol) {
        if (this.method != symbol.getMethod()) {
            return false;
        }
        return this.modes.contains(WILDCARD_TOKEN) || this.modes.containsAll(symbol.getModes());
    }

    public boolean implies(PayMethod payMethod, String payMode) {
        return this.implies(new PaymentSymbol(payMethod, payMode));
    }

    public String toString() {
        return this.method + PART_DIVIDER_TOKEN + Joiner.on((String)SUBPART_DIVIDER_TOKEN).join(this.modes);
    }

    public PayMethod getMethod() {
        return this.method;
    }

    public Set<String> getModes() {
        return this.modes;
    }

    public void setMethod(PayMethod method) {
        this.method = method;
    }

    public void setModes(Set<String> modes) {
        this.modes = modes;
    }
}

