/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.payment.core;

import com.xunyi.beast.payment.core.PayMethod;
import com.xunyi.beast.payment.core.PayRoute;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class App {
    private static final Logger log = LoggerFactory.getLogger(App.class);
    private String appId;
    private List<PayRoute> routes;
    private String tradeNotifyTarget;
    private String orderNotifyTarget;

    public String lookup(PayMethod payMethod, String payMode) {
        Optional<PayRoute> routeOptional = this.routes.stream().filter(route -> route.allow(payMethod, payMode)).findFirst();
        if (routeOptional.isEmpty()) {
            return null;
        }
        PayRoute route2 = routeOptional.get();
        return route2.getChannelId();
    }

    public String getAppId() {
        return this.appId;
    }

    public List<PayRoute> getRoutes() {
        return this.routes;
    }

    public String getTradeNotifyTarget() {
        return this.tradeNotifyTarget;
    }

    public String getOrderNotifyTarget() {
        return this.orderNotifyTarget;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setRoutes(List<PayRoute> routes) {
        this.routes = routes;
    }

    public void setTradeNotifyTarget(String tradeNotifyTarget) {
        this.tradeNotifyTarget = tradeNotifyTarget;
    }

    public void setOrderNotifyTarget(String orderNotifyTarget) {
        this.orderNotifyTarget = orderNotifyTarget;
    }
}

