package com.xunyi.beast.payment.core;

import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Getter @Setter
public class PayRoute {

    @NotNull
    private PaymentSymbol symbol;

    @NotBlank
    private String channelId;

    public boolean allow(PayMethod payMethod, String payMode) {
        return this.symbol.implies(payMethod, payMode);
    }
}
