package com.xunyi.beast.payment.client.dto;

import com.google.common.collect.Maps;
import com.xunyi.beast.payment.core.PayMethod;
import lombok.*;
import org.springframework.lang.Nullable;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Map;

@Getter
@Setter
@Builder
@NoArgsConstructor()
@AllArgsConstructor()
public class CreateTradeInput {

    @NotBlank(message = "PAYMENT_ERR_PARAMETER_BAD")
    private String outTradeNo;

    @NotBlank(message = "PAYMENT_ERR_PARAMETER_BAD")
    private String subject;

    private String body;

    /**
     * 指定渠道ID，则不进行支付路由。
     * 用在提前查询支付路由。并根据配置设置extra的情况
     */
    @Nullable
    private String channelId;

    //支付渠道：微信，支付宝，
    @NotNull(message = "PAYMENT_ERR_PARAMETER_BAD")
    private PayMethod payMethod;

    //支付模式:
    private String payMode;

    //货币
    private String currency;

    @NotNull(message = "PAYMENT_ERR_PARAMETER_BAD")
    private BigDecimal amount;

    private Map<String, String> extra = Maps.newHashMap();

    //通知目标
    @Nullable
    private String notifyTarget;

    //创建交易的用户IP
    @NotNull(message = "PAYMENT_ERR_PARAMETER_BAD")
    private String createUserIp;


}
