package com.xunyi.beast.payment.client.dto;

import com.xunyi.beast.data.money.SimpleMoney;
import lombok.*;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

@Getter
@Setter
@Builder
@NoArgsConstructor()
@AllArgsConstructor()
public class CreatePaymentOrderInput {

    @NotBlank(message = "PAYMENT_ERR_PARAMETER_BAD")
    private String outOrderNo;

    @NotBlank(message = "PAYMENT_ERR_PARAMETER_BAD")
    private String subject;

    private String body;

    //货币
    private String currency;

    @NotNull(message = "PAYMENT_ERR_PARAMETER_BAD")
    private BigDecimal amount;
}
