package com.xunyi.beast.payment.client;

import com.xunyi.beast.data.message.ReturnResult;
import com.xunyi.beast.payment.client.dto.CreatePaymentOrderInput;
import com.xunyi.beast.payment.client.dto.CreatePaymentOrderOutput;
import com.xunyi.beast.payment.client.dto.CreatePaymentOrderTradeInput;
import com.xunyi.beast.payment.client.dto.CreatePaymentOrderTradeOutput;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Service
@FeignClient("beast-payment-order")
public interface PaymentOrderClient {

    @PostMapping("/api/apps/{appId}/payment-orders")
    ReturnResult<CreatePaymentOrderOutput> createOrder(
            @PathVariable("appId") String appId,
            @RequestBody CreatePaymentOrderInput input
    );

    @PostMapping("/api/apps/{appId}/payment-orders/{orderNo}/trades")
    ReturnResult<CreatePaymentOrderTradeOutput> createOrderTrade(
            @PathVariable("appId") String appId,
            @PathVariable("orderNo") String orderNo,
            @RequestBody CreatePaymentOrderTradeInput input
    );

}
