package com.xunyi.beast.payment.client;

import com.xunyi.beast.data.message.ReturnResult;
import com.xunyi.beast.payment.client.dto.CreatePaymentOrderOutput;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Service
@FeignClient("beast-payment-order")
public interface PaymentOrderClient {

    @PostMapping("/api/apps/{appId}/payment-orders")
    ReturnResult<CreatePaymentOrderOutput> create(
            @PathVariable("appId") String appId,
            @RequestBody CreatePaymentOrderOutput input
    );

}
