/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.payment.channel.paypal;

import com.paypal.api.payments.Amount;
import com.paypal.api.payments.Payer;
import com.paypal.api.payments.Payment;
import com.paypal.api.payments.PaymentExecution;
import com.paypal.api.payments.RedirectUrls;
import com.paypal.api.payments.Transaction;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.PayPalRESTException;
import java.math.BigDecimal;
import java.util.ArrayList;

public class PayPalClient {
    private APIContext context;

    public PayPalClient(APIContext context) {
        this.context = context;
    }

    public APIContext getContext() {
        return this.context;
    }

    public Payment createPayment(String currency, BigDecimal total, String description, String cancelUrl, String successUrl) throws PayPalRESTException {
        String intent = "";
        String method = "";
        Amount amount = new Amount();
        amount.setCurrency(currency);
        amount.setTotal(total.toString());
        Transaction transaction = new Transaction();
        transaction.setDescription(description);
        transaction.setAmount(amount);
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        transactions.add(transaction);
        Payer payer = new Payer();
        payer.setPaymentMethod(method);
        Payment payment = new Payment();
        payment.setIntent(intent);
        payment.setPayer(payer);
        payment.setTransactions(transactions);
        RedirectUrls redirectUrls = new RedirectUrls();
        redirectUrls.setCancelUrl(cancelUrl);
        redirectUrls.setReturnUrl(successUrl);
        payment.setRedirectUrls(redirectUrls);
        return payment.create(this.context);
    }

    public Payment getPayment(String paymentId) throws PayPalRESTException {
        return Payment.get((APIContext)this.context, (String)paymentId);
    }

    public Payment executePayment(String paymentId, String payerId) throws PayPalRESTException {
        Payment payment = new Payment();
        payment.setId(paymentId);
        PaymentExecution paymentExecution = new PaymentExecution();
        paymentExecution.setPayerId(payerId);
        return payment.execute(this.context, paymentExecution);
    }
}

