package com.xunyi.beast.payment.channel.wechat.api.model;

import lombok.Getter;
import lombok.Setter;
import org.springframework.lang.Nullable;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * 提交退款申请后，通过调用该接口查询退款状态。退款有一定延时，
 * 用零钱支付的退款20分钟内到账，银行卡支付的退款3个工作日后重新查询退款状态。
 */
@XmlRootElement(name = "xml")
@Getter @Setter
public class PayRefundQueryRequest extends BaseRequest {

    //二选一
    @XmlElement(name = "transaction_id")
    private String transactionId;

    @XmlElement(name = "out_trade_no")
    private String outTradeNo;

    @XmlElement(name = "out_refund_no")
    private String outRefundNo;

    @XmlElement(name = "refund_id")
    private String refundId;

    @Nullable
    @XmlElement(name = "offset")
    private Integer offset;

}
