package com.xunyi.beast.payment.channel.wechat;


import com.xunyi.beast.payment.channel.AbstractClientFactory;
import com.xunyi.beast.payment.channel.wechat.api.WechatPayHttpClient;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;

public class WechatPayClientFactory extends AbstractClientFactory<WechatPayClient, WechatPayClientFactory.Config> {

    public static final WechatSignType SIGN_TYPE = WechatSignType.MD5;

    public static final String SANDBOX_TARGET = "https://api.mch.weixin.qq.com/sandboxnew/";
    public static final String TARGET = "https://api.mch.weixin.qq.com";



    public WechatPayClientFactory() {

    }

    public WechatPayClient newClient(Config config) {
        WechatPayClient client = new WechatPayClient(config.endpoint);
        client.setAppId(config.appId);
        client.setKey(config.key);
        client.setMchId(config.mchId);
        return client;
    }

    public static final String APP_ID_NAME = "appId";
    public static final String KEY_NAME = "key";
    public static final String DOMAIN_NAME = "domain";
    @Getter
    @Setter
    public static class Config {


        @NotBlank
        private String endpoint;

        @NotBlank
        private String appId;

        @NotBlank
        private String key;

        @NotBlank
        private String mchId;

        @NotBlank
        private String domain;

    }

}
