/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.payment.channel.wechat;

import com.xunyi.beast.payment.channel.wechat.WechatPayUtils;
import com.xunyi.beast.payment.channel.wechat.WechatSignType;
import com.xunyi.beast.payment.channel.wechat.api.WechatPayHttpClient;
import com.xunyi.beast.payment.channel.wechat.api.model.BaseRequest;
import com.xunyi.beast.payment.channel.wechat.api.model.CreateUnifiedOrderRequest;
import com.xunyi.beast.payment.channel.wechat.api.model.CreateUnifiedOrderResponse;
import com.xunyi.beast.payment.channel.wechat.api.model.PayRefundQueryRequest;
import com.xunyi.beast.payment.channel.wechat.api.model.PayRefundQueryResponse;
import com.xunyi.beast.payment.channel.wechat.api.model.PayRefundRequest;
import com.xunyi.beast.payment.channel.wechat.api.model.PayRefundResponse;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jaxb.JAXBContextFactory;
import feign.jaxb.JAXBDecoder;
import feign.jaxb.JAXBEncoder;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.cloud.openfeign.support.SpringMvcContract;

public class WechatPayClient {
    private String appId;
    private String mchId;
    private String key;
    private WechatPayHttpClient client;
    private WechatSignType signType = WechatSignType.MD5;

    public WechatPayClient(String endpoint) {
        JAXBContextFactory jaxbFactory = new JAXBContextFactory.Builder().build();
        this.client = (WechatPayHttpClient)Feign.builder().contract((Contract)new SpringMvcContract()).encoder((Encoder)new JAXBEncoder(jaxbFactory)).decoder((Decoder)new JAXBDecoder(jaxbFactory)).target(WechatPayHttpClient.class, endpoint);
    }

    public void config(BaseRequest request) {
        request.setAppId(this.appId);
        request.setMchId(this.mchId);
        request.setNonceStr(RandomStringUtils.randomAlphanumeric((int)16));
        request.setSignType(this.signType.name());
        Map<String, String> params = request.getSignParams();
        String sign = WechatPayUtils.generateSignature(params, this.key, this.signType);
        request.setSign(sign);
    }

    public CreateUnifiedOrderResponse createUnifiedOrder(CreateUnifiedOrderRequest request) throws JAXBException {
        this.config(request);
        return this.client.createUnifiedOrder(request);
    }

    public PayRefundResponse refund(PayRefundRequest request) {
        this.config(request);
        return this.client.refund(request);
    }

    public PayRefundQueryResponse queryRefund(PayRefundQueryRequest request) {
        this.config(request);
        return this.client.queryRefund(request);
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void setClient(WechatPayHttpClient client) {
        this.client = client;
    }

    public void setSignType(WechatSignType signType) {
        this.signType = signType;
    }

    public WechatSignType getSignType() {
        return this.signType;
    }
}

