/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.payment.channel.wechat;

import com.xunyi.beast.payment.channel.AbstractClientFactory;
import com.xunyi.beast.payment.channel.wechat.WechatPayClient;
import com.xunyi.beast.payment.channel.wechat.WechatSignType;
import javax.validation.constraints.NotBlank;

public class WechatPayClientFactory
extends AbstractClientFactory<WechatPayClient, Config> {
    public static final WechatSignType SIGN_TYPE = WechatSignType.MD5;
    public static final String SANDBOX_TARGET = "https://api.mch.weixin.qq.com/sandboxnew/";
    public static final String TARGET = "https://api.mch.weixin.qq.com";
    public static final String APP_ID_NAME = "appId";
    public static final String KEY_NAME = "key";
    public static final String DOMAIN_NAME = "domain";

    @Override
    public WechatPayClient newClient(Config config) {
        WechatPayClient client = new WechatPayClient(config.endpoint);
        client.setAppId(config.appId);
        client.setKey(config.key);
        client.setMchId(config.mchId);
        return client;
    }

    public static class Config {
        @NotBlank
        private String endpoint;
        @NotBlank
        private String appId;
        @NotBlank
        private String key;
        @NotBlank
        private String mchId;
        @NotBlank
        private String domain;

        public String getEndpoint() {
            return this.endpoint;
        }

        public String getAppId() {
            return this.appId;
        }

        public String getKey() {
            return this.key;
        }

        public String getMchId() {
            return this.mchId;
        }

        public String getDomain() {
            return this.domain;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setMchId(String mchId) {
            this.mchId = mchId;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }
    }
}

