package com.xunyi.beast.payment.channel.wechat.api.model;

import lombok.Getter;
import lombok.Setter;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

/**
 *
 */
@XmlRootElement(name = "xml")
@Getter @Setter
public class PayRefundRequest extends BaseRequest {

    //二选一
    @XmlElement(name = "transaction_id")
    private String transactionId;

    @XmlElement(name = "out_trade_no")
    private String outTradeNo;


    //退款单号
    @XmlElement(name = "out_refund_no")
    private String outRefundNo;

    //订单金额,单位为分
    @XmlElement(name = "total_fee")
    private int totalFee;

    //退款总金额,单位为分
    @XmlElement(name = "refund_fee")
    private int refundFee;

    //退款货币总类
    @XmlElement(name = "refund_fee_type")
    private String refundFeeType;

    //退款原因
    @XmlElement(name = "refund_desc")
    private String refundDesc;

    //退款资金来源
    @XmlElement(name = "refund_account")
    private String refundAccount;

    //option: 不允许带参数, 如果设置，商户平台配置的回调地址将失效
    @XmlElement(name = "notify_url")
    private String notifyUrl;

    @XmlTransient
    public String getTransactionId() {
        return transactionId;
    }

    @XmlTransient
    public String getOutTradeNo() {
        return outTradeNo;
    }

    @XmlTransient
    public String getOutRefundNo() {
        return outRefundNo;
    }

    @XmlTransient
    public int getTotalFee() {
        return totalFee;
    }

    @XmlTransient
    public int getRefundFee() {
        return refundFee;
    }

    @XmlTransient
    public String getRefundFeeType() {
        return refundFeeType;
    }

    @XmlTransient
    public String getRefundDesc() {
        return refundDesc;
    }

    @XmlTransient
    public String getRefundAccount() {
        return refundAccount;
    }

    @XmlTransient
    public String getNotifyUrl() {
        return notifyUrl;
    }
}
