package com.xunyi.beast.payment.channel.wechat.api.model;

import com.google.common.collect.Maps;
import lombok.Setter;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@Setter
public class BaseRequest {

    //公众账号ID
    @XmlElement(name = "appid")
    private String appId;

    //商户号
    @XmlElement(name = "mch_id")
    private String mchId;

    //随机字符串
    @XmlElement(name = "nonce_str")
    private String nonceStr;

    //签名
    @XmlElement(name = "sign")
    private String sign;

    //签名类型
    @XmlElement(name = "sign_type")
    private String signType = "HMAC-SHA256";

    @XmlTransient
    public String getAppId() {
        return appId;
    }

    @XmlTransient
    public String getMchId() {
        return mchId;
    }

    @XmlTransient
    public String getNonceStr() {
        return nonceStr;
    }

    @XmlTransient
    public String getSign() {
        return sign;
    }

    @XmlTransient
    public String getSignType() {
        return signType;
    }

    public Map<String, String> getSignParams() {
        Map<String, String> params = Maps.newHashMap();
        params.put("appid", appId);
        params.put("mch_id", mchId);
        params.put("nonce_str", nonceStr);
        params.put("sign_type", signType);
        return params.entrySet().stream().filter(item -> Objects.nonNull(item.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}
