package com.xunyi.beast.payment.channel.wechat.api.model;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement()
@Getter
@Setter
@ToString
public class PayRefundResponse extends ReturnMessage {

    @XmlElement(name = "result_code")
    private String resultCode;

    @XmlElement(name = "err_code")
    private String errCode;

    @XmlElement(name = "err_code_des")
    private String errCodeDes;


    //调用接口提交的: 公众账号ID
    @XmlElement(name = "appid")
    private String appId;

    //调用接口提交的: 商户号
    @XmlElement(name = "mch_id")
    private String mchId;


    //调用接口提交的: 随机字符串
    @XmlElement(name = "nonce_str")
    private String nonceStr;

    //调用接口提交的: 签名
    private String sign;


    //二选一
    @XmlElement(name = "transaction_id")
    private String transactionId;

    @XmlElement(name = "out_trade_no")
    private String outTradeNo;

    //退款单号
    @XmlElement(name = "out_refund_no")
    private String outRefundNo;

    //微信退款单号
    @XmlElement(name = "refund_id")
    private String refundId;

    //退款总金额,单位为分
    @XmlElement(name = "refund_fee")
    private int refundFee;

    //应结退款金额
    @XmlElement(name = "settlement_refund_fee")
    private Integer settlementRefundFee;

    //标价金额
    @XmlElement(name = "total_fee")
    private int totalFee;

    @XmlElement(name = "settlement_total_fee")
    private Integer settlementTotalFee;

    //标价币种
    @XmlElement(name = "total_type")
    private String feeType;

    //现金支付金额
    @XmlElement(name = "cash_fee")
    private Integer cashFee;

    @XmlElement(name = "cash_fee_type")
    private String cashFeeType;

    //现金退款金额

    //代金券
    //退款代金券ID

    public boolean isCreateSuccess() {
        return "SUCCESS".equals(this.resultCode);
    }

    @XmlTransient
    public String getResultCode() {
        return resultCode;
    }

    @XmlTransient
    public String getErrCode() {
        return errCode;
    }

    @XmlTransient
    public String getErrCodeDes() {
        return errCodeDes;
    }

    @XmlTransient
    public String getAppId() {
        return appId;
    }

    @XmlTransient
    public String getMchId() {
        return mchId;
    }

    @XmlTransient
    public String getNonceStr() {
        return nonceStr;
    }

    @XmlTransient
    public String getSign() {
        return sign;
    }

    @XmlTransient
    public String getTransactionId() {
        return transactionId;
    }

    @XmlTransient
    public String getOutTradeNo() {
        return outTradeNo;
    }

    @XmlTransient
    public String getOutRefundNo() {
        return outRefundNo;
    }

    @XmlTransient
    public String getRefundId() {
        return refundId;
    }

    @XmlTransient
    public int getRefundFee() {
        return refundFee;
    }

    @XmlTransient
    public Integer getSettlementRefundFee() {
        return settlementRefundFee;
    }

    @XmlTransient
    public int getTotalFee() {
        return totalFee;
    }

    @XmlTransient
    public Integer getSettlementTotalFee() {
        return settlementTotalFee;
    }

    @XmlTransient
    public String getFeeType() {
        return feeType;
    }

    @XmlTransient
    public Integer getCashFee() {
        return cashFee;
    }

    @XmlTransient
    public String getCashFeeType() {
        return cashFeeType;
    }
}
