/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.grpc;

import com.google.common.collect.Lists;
import com.xunyi.beast.grpc.GRPCChannelFactory;
import com.xunyi.beast.grpc.GRPCChannelsProperties;
import com.xunyi.beast.grpc.GRPCClient;
import com.xunyi.beast.grpc.GRPCClientBeanPostProcessor;
import com.xunyi.beast.grpc.discovery.DiscoveryChannelFactory;
import com.xunyi.beast.grpc.sleuth.TraceClientInterceptor;
import io.grpc.LoadBalancer;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.simple.SimpleDiscoveryClientAutoConfiguration;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryClientConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={GRPCChannelsProperties.class})
@ConditionalOnClass(value={GRPCChannelFactory.class, LoadBalancer.class})
@AutoConfigureAfter(value={SimpleDiscoveryClientAutoConfiguration.class, ConsulDiscoveryClientConfiguration.class})
@ConditionalOnBean(value={DiscoveryClient.class})
public class GRPCDiscoveryAutoConfiguration {
    @Bean
    @ConditionalOnClass(value={GRPCClient.class})
    public GRPCClientBeanPostProcessor clientBeanPostProcessor() {
        return new GRPCClientBeanPostProcessor();
    }

    @Bean
    public GRPCChannelFactory discoveryClientChannelFactory(GRPCChannelsProperties properties, DiscoveryClient discoveryClient, @Autowired(required=false) TraceClientInterceptor interceptor) {
        ArrayList interceptors = Lists.newArrayList();
        if (interceptor != null) {
            interceptors.add(interceptor);
        }
        return new DiscoveryChannelFactory(properties, discoveryClient, interceptors);
    }
}

