package com.xunyi.beast.grpc;


import com.google.common.collect.Lists;
import com.xunyi.beast.grpc.discovery.DiscoveryChannelFactory;
import com.xunyi.beast.grpc.sleuth.TraceClientInterceptor;
import io.grpc.ClientInterceptor;
import io.grpc.LoadBalancer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.simple.SimpleDiscoveryClientAutoConfiguration;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryClientConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.List;

@Configuration
@EnableConfigurationProperties(value = com.xunyi.beast.grpc.GRPCChannelsProperties.class)
@ConditionalOnClass({com.xunyi.beast.grpc.GRPCChannelFactory.class, LoadBalancer.class})
@AutoConfigureAfter({SimpleDiscoveryClientAutoConfiguration.class, ConsulDiscoveryClientConfiguration.class})
@ConditionalOnBean({DiscoveryClient.class})
public class GRPCDiscoveryAutoConfiguration {


//    @ConditionalOnMissingBean
//    @Bean
//    public LoadBalancer.Factory grpcLoadBalancerFactory() {
//        return RoundRobinLoadBalancerFactory.getInstance();
//    }

    @Bean
    @ConditionalOnClass(com.xunyi.beast.grpc.GRPCClient.class)
    public com.xunyi.beast.grpc.GRPCClientBeanPostProcessor clientBeanPostProcessor() {
        return new com.xunyi.beast.grpc.GRPCClientBeanPostProcessor();
    }


    @Bean
    public com.xunyi.beast.grpc.GRPCChannelFactory discoveryClientChannelFactory(com.xunyi.beast.grpc.GRPCChannelsProperties properties,
                                                                                 DiscoveryClient discoveryClient,
//                                                            LoadBalancer.Factory loadBalancerFactory,
                                                                                 @Autowired(required = false) TraceClientInterceptor interceptor
//                                                            @Autowired(required = false) List<ClientInterceptor> interceptors
                                                            ) {
        List<ClientInterceptor> interceptors = Lists.newArrayList();
        if (interceptor != null) {
            interceptors.add(interceptor);
        }
        return new DiscoveryChannelFactory(properties, discoveryClient, interceptors);
    }

//    @Configuration
//    protected static class DiscoveryGRPCClientAutoConfiguration {
//        protected DiscoveryGRPCClientAutoConfiguration() {
//        }
//
//        @ConditionalOnMissingBean
//
//    }

//    @Configuration
//    @ConditionalOnBean({org.springframework.cloud.sleuth.Tracer.class}) //这个不生效
//    protected static class TracerAutoConfiguration {
//
//
//        @ConditionalOnMissingBean
//        @Bean
//        public TraceClientInterceptor interceptor(Tracer tracer) {
//            return new TraceClientInterceptor(tracer, new MetadataInjector());
//        }
//
//    }
}
