/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.feaure.lunar;

import com.xunyi.beast.feaure.lunar.Lunar;
import com.xunyi.beast.feaure.lunar.LunarDate;
import com.xunyi.beast.feaure.lunar.LunarSolarConverter;
import com.xunyi.beast.feaure.lunar.LunarYearMonth;
import com.xunyi.beast.feaure.lunar.Solar;
import java.time.LocalDate;

public class LunarUtils {
    private static final String[] CHINESE_NUMBER = new String[]{"\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u5341\u4e00", "\u5341\u4e8c"};
    private static final String[] CHINESE_TEL = new String[]{"\u521d", "\u5341", "\u5eff", "\u5345"};

    private static String getMonthText(int month) {
        if (month == 1) {
            return "\u6b63\u6708";
        }
        if (month == 12) {
            return "\u814a\u6708";
        }
        return CHINESE_NUMBER[month - 1] + "\u6708";
    }

    private static String getDayText(int day) {
        int digitsIndex = (day % 10 == 0 ? 10 : day % 10) - 1;
        if (day <= 10) {
            return CHINESE_TEL[0] + CHINESE_NUMBER[digitsIndex];
        }
        return CHINESE_TEL[day / 10] + CHINESE_NUMBER[digitsIndex];
    }

    public static LocalDate convertSolar(LunarDate date) {
        Lunar lunar = new Lunar();
        lunar.lunarYear = date.getYear();
        lunar.lunarMonth = date.getMonth();
        lunar.lunarDay = date.getDayOfMonth();
        Solar solar = LunarSolarConverter.LunarToSolar(lunar);
        return LocalDate.of(solar.solarYear, solar.solarMonth, solar.solarDay);
    }

    public static LunarDate convertLunar(LocalDate date) {
        Solar solar = new Solar();
        solar.solarYear = date.getYear();
        solar.solarMonth = date.getMonthValue();
        solar.solarDay = date.getDayOfMonth();
        Lunar lunar = LunarSolarConverter.SolarToLunar(solar);
        return LunarDate.of(lunar.lunarYear, lunar.lunarMonth, lunar.lunarDay);
    }

    public static String format(LunarDate date) {
        String year = LunarSolarConverter.lunarYearToGanZhi(date.getYear());
        String month = LunarUtils.getMonthText(date.getMonth());
        String day = LunarUtils.getDayText(date.getDayOfMonth());
        return year + month + day;
    }

    public static String format(LunarYearMonth yearMonth) {
        String year = LunarSolarConverter.lunarYearToGanZhi(yearMonth.getYear());
        String month = LunarUtils.getMonthText(yearMonth.getMonth());
        return year + month;
    }

    public static String formatMonth(int month) {
        return LunarUtils.getMonthText(month);
    }

    public static String convertGanzhiFromYear(int year) {
        return LunarSolarConverter.lunarYearToGanZhi(year);
    }
}

