package com.xunyi.beast.feaure.lunar.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.xunyi.beast.feaure.lunar.LunarUtils;
import com.xunyi.beast.feaure.lunar.LunarYearMonth;


import java.io.IOException;

/**
 *  \@JsonSerialize(using = LunarYearMonthJsonSerializer.class)
 *  private LunarYearMonth lunarYearMonth;
 */
public class LunarYearMonthJsonSerializer extends JsonSerializer<LunarYearMonth> {
    @Override
    public void serialize(LunarYearMonth value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value != null) {
            gen.writeString(LunarUtils.format(value));
        } else {
            gen.writeNull();
        }
    }
}
