package com.xunyi.beast.feaure.lunar;

import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
public class LunarYearMonth {
    private int year;
    private int month;

    public LunarYearMonth(int year, int month) {
        this.year = year;
        this.month = month;
    }

    public static LunarYearMonth of(int year, int month) {
        return new LunarYearMonth(year, month);
    }

    public LunarDate atDay(int dayOfMonth) {
        return LunarDate.of(year, month, dayOfMonth);
    }

    public LunarDate atEndOfMonth() {
        return LunarDate.of(year, month, LunarSolarConverter.lengthOfYearMonth(year, month));
    }
}
