package com.xunyi.beast.feaure.lunar;

import java.time.LocalDate;

public class LunarUtils {

    private final static String CHINESE_NUMBER[] = { "一", "二", "三", "四", "五", "六", "七",
            "八", "九", "十", "十一", "十二" };
    private final static String CHINESE_TEL[] = { "初", "十", "廿", "卅" };

    private static String getMonthText(int month) {
        if (month == 1) {
            return "正月";
        }
        if (month == 12) {
            return "腊月";
        }
        return CHINESE_NUMBER[month - 1 ] + "月";
    }

    private static String getDayText(int day) {
        int digitsIndex = (day % 10 == 0 ?  10 : day % 10)  - 1;
        if (day <= 10) {
            return CHINESE_TEL[0] + CHINESE_NUMBER[digitsIndex];
        } else {
            return CHINESE_TEL[day/10] + CHINESE_NUMBER[digitsIndex];
        }
    }

    public static LocalDate convertSolar(LunarDate date) {
        Lunar lunar = new Lunar();
        lunar.lunarYear = date.getYear();
        lunar.lunarMonth = date.getMonth();
        lunar.lunarDay = date.getDayOfMonth();
        Solar solar = LunarSolarConverter.LunarToSolar(lunar);
        return LocalDate.of(solar.solarYear, solar.solarMonth, solar.solarDay);
    }

    public static LunarDate convertLunar(LocalDate date) {
        Solar solar = new Solar();
        solar.solarYear = date.getYear();
        solar.solarMonth = date.getMonthValue();
        solar.solarDay = date.getDayOfMonth();
        Lunar lunar = LunarSolarConverter.SolarToLunar(solar);
        return LunarDate.of(lunar.lunarYear, lunar.lunarMonth, lunar.lunarDay);
    }
    public static String format(LunarDate date) {
        String year = LunarSolarConverter.lunarYearToGanZhi(date.getYear());
        String month = getMonthText(date.getMonth());
        String day = getDayText(date.getDayOfMonth());
        return year + month + day;
    }

    public static String format(LunarYearMonth yearMonth) {
        String year = LunarSolarConverter.lunarYearToGanZhi(yearMonth.getYear());
        String month = getMonthText(yearMonth.getMonth());
        return year + month;
    }

    public static String formatMonth(int month) {
        return getMonthText(month);
    }

    public static String convertGanzhiFromYear(int year) {
        return LunarSolarConverter.lunarYearToGanZhi(year);
    }

}
