package com.xunyi.beast.feaure.lunar;

import lombok.Getter;
import lombok.Setter;

import java.time.LocalDate;

@Getter
@Setter
public class LunarDate {

    private int year;
    private int month;
    private int dayOfMonth;

    public LunarDate(int year, int month, int dayOfMonth) {
        this.year = year;
        this.month = month;
        this.dayOfMonth = dayOfMonth;
    }

    public static LunarDate of(int year, int month, int dayOfMonth) {
        return new LunarDate(year, month, dayOfMonth);
    }

    public static LunarDate now() {
        return LunarUtils.convertLunar(LocalDate.now());
    }
}
