package com.xunyi.beast.exporter;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class FetchIterator<E> implements Iterator<E>{

    protected long cursor = 0;
    protected Iterator<E> innerIter = Collections.emptyIterator();

    protected abstract Iterator<E> fetchNextIterator();

    public boolean checkNext() {
        if (!innerIter.hasNext()) {
            this.innerIter = this.fetchNextIterator();

            return this.innerIter.hasNext();
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        return checkNext();
    }

    @Override
    public E next() {
        if (!this.checkNext()) {
            throw new NoSuchElementException();
        }
        E next = innerIter.next();
        cursor += 1;
        return next;
    }
}
