package com.xunyi.beast.exporter;

import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;

public abstract class CSVFileExporter<T> extends AbstractExporter<T>{

    private CSVPrinter printer;

    public CSVFileExporter(OutputStream os, boolean withBOM) throws IOException {
        super();
        if (withBOM) {
            writeBOM(os);
        }
        OutputStreamWriter writer = new OutputStreamWriter(os);
        CSVFormat format = CSVFormat.DEFAULT.withHeader();
        this.printer = new CSVPrinter(writer, format);
    }

    private void writeBOM(OutputStream os) throws IOException {
        os.write(new byte[]{(byte)0xEF, (byte)0xBB, (byte)0xBF});
    }

    @Override
    public void flush() throws IOException {
        this.printer.flush();
    }

    @Override
    public void writeObject(T object) throws IOException {
        List<String> row = apply(object);
        this.printer.printRecord(row);
    }

    public abstract List<String> apply(T object);
}
