/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.data.message.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.xunyi.beast.data.message.ErrorInfo;
import com.xunyi.beast.data.message.ErrorMessageSource;
import com.xunyi.beast.data.message.XYError;
import java.io.IOException;

public class MessageModule
extends SimpleModule {
    private ErrorMessageSource errorMessageSource;

    public MessageModule(ErrorMessageSource errorMessageSource) {
        super(Version.unknownVersion());
        this.errorMessageSource = errorMessageSource;
        this.addSerializer(XYError.class, (JsonSerializer)new ErrorSerializer());
    }

    public class ErrorSerializer
    extends StdScalarSerializer<XYError> {
        private ErrorSerializer() {
            super(XYError.class);
        }

        private String convertMessageCode(String type) {
            return type.toLowerCase().replace("_", ".");
        }

        public void serialize(XYError error, JsonGenerator gen, SerializerProvider provider) throws IOException {
            String errorCode = error.getCode();
            String message = MessageModule.this.errorMessageSource.getMessage(error);
            gen.writeObject((Object)new ErrorInfo(errorCode, message));
        }
    }
}

