/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.data.money.jackson.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.xunyi.beast.data.money.SimpleMoney;
import java.io.IOException;
import java.math.BigDecimal;

public class SimpleMoneyDeserializer
extends StdScalarDeserializer<SimpleMoney> {
    protected final SimpleMoney empty = null;

    public SimpleMoneyDeserializer() {
        super(SimpleMoney.class);
    }

    public SimpleMoney deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (p.hasToken(JsonToken.VALUE_NUMBER_FLOAT)) {
            return SimpleMoney.of(Float.valueOf(p.getFloatValue()));
        }
        if (p.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            return SimpleMoney.of(p.getIntValue());
        }
        switch (p.getCurrentTokenId()) {
            case 6: {
                String text = p.getText().trim();
                if (text.length() == 0) {
                    return this.empty;
                }
                return SimpleMoney.of(new BigDecimal(p.getText()));
            }
            case 11: {
                return this.empty;
            }
        }
        return (SimpleMoney)ctxt.handleUnexpectedToken(this._valueClass, p);
    }
}

