package com.xunyi.beast.data.util;

import com.google.common.base.Strings;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.Collections;

public class IPMatcher {


    public static boolean some(String ip, Collection<String> rules) {
        if (CollectionUtils.isEmpty(rules)) {
            throw new IllegalArgumentException("rules not is empty");
        }
        for (String rule : rules) {
            if (match(ip, rule)) {
                return true;
            }
        }
        return false;
    }

    public static boolean every(String ip, Collection<String> rules) {
        if (CollectionUtils.isEmpty(rules)) {
            throw new IllegalArgumentException("rules not is empty");
        }
        for (String rule : rules) {
            if (!match(ip, rule)) {
                return false;
            }
        }
        return true;
    }
    /**
     * @param ip ip
     * @param rule 仅支持*匹配
     * @return 是否匹配
     */
    public static boolean match(String ip, String rule) {
        if (Strings.isNullOrEmpty(ip) || Strings.isNullOrEmpty(rule)) {
            throw new IllegalArgumentException("invalid match ip:" + ip + " rule:" +rule);
        }
        String[] ipItems = ip.split("\\.");
        String[] ruleItems = rule.split("\\.");
        if (ipItems.length != 4 || ruleItems.length != 4) {
            throw new IllegalArgumentException("invalid match ip:" + ip + " rule:" +rule);
        }
        for (int i = 0; i < 4; i++) {
            if (!"*".equals(ruleItems[i]) && !ruleItems[i].equals(ipItems[i])) {
                return false;
            }
        }
        return true;
    }
}
