package com.xunyi.beast.data.message;

public interface IErrorOwner {

    String getErrorCode();

    default Return<?> toReturn() {
        return toReturn(new Object[]{});
    }

    default Return<?> toReturn(Object... args) {
        return Returns.error(toError(args));
    };

    default XYError toError() {
        return toError(new Object[]{});
    }
    default XYError toError(Object... args) {
        return new XYError(this.getErrorCode(), args);
    }

    default ErrorException toException() {
        return toException(new Object[]{});
    }

    default ErrorException toException(Object... args) {
        return new ErrorException(toError(args));
    }
}
