/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.data.redis.serializer;

import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.time.Instant;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.format.datetime.standard.InstantFormatter;

public class InstantRedisSerializer
implements RedisSerializer<Instant> {
    private InstantFormatter formatter = new InstantFormatter();

    public byte[] serialize(Instant instant) throws SerializationException {
        if (instant == null) {
            return null;
        }
        String time = this.formatter.print(instant, null);
        return time.getBytes(StandardCharsets.UTF_8);
    }

    public Instant deserialize(byte[] bytes) throws SerializationException {
        if (bytes == null) {
            return null;
        }
        String time = new String(bytes, StandardCharsets.UTF_8);
        try {
            return this.formatter.parse(time, null);
        }
        catch (ParseException e) {
            throw new SerializationException("serialization exception", (Throwable)e);
        }
    }
}

