package com.xunyi.beast.data.message;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.function.Supplier;

@ToString
@Getter @Setter
public class ReturnResult<T> implements Serializable {

    private ErrorInfo error;

    private T data;

    public ReturnResult() {
    }

    public boolean hasError() {
        return this.error != null;
    }


    public T orElse(T other) {
        if (hasError()) {
            return other;
        }
        return data;
    }

    public T orElseGet(Supplier<? extends T> supplier) {
        if (hasError()) {
            return supplier.get();
        }
        return data;
    }

    public T orElseThrow() {
        if (hasError()) {
            throw new ErrorException(error);
        }
        return data;
    }

    public <X extends Throwable> T orElseThrow(ErrorSupplier<X, ErrorInfo> exceptionSupplier) throws X {
        if (hasError()) {
            throw exceptionSupplier.get(getError());
        }
        return data;
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (hasError()) {
            throw exceptionSupplier.get();
        }
        return data;
    }




}
