package com.xunyi.beast.data.message;

import org.springframework.context.MessageSource;

import java.util.Locale;

public class ErrorMessageSource {

    public MessageSource messageSource;

    public ErrorMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    private String convertMessageCode(String type) {
        return type.toLowerCase().replace("_", ".");
    }

    public String getMessage(IError error) {
        String errorCode = error.getCode();
        Object[] args = null;
        if (error instanceof XYError) {
            args = ((XYError)error).getArgs();
        }
        return getMessage(errorCode, args);
    }

    public String getMessage(String errorCode, Object... args) {
        String messageCode = convertMessageCode(errorCode);
        String message = null;
        try {
            message = messageSource.getMessage(messageCode, args, Locale.CHINA);
        } catch (Exception ignore) {
        }
        if (message == null) {
            message = errorCode;
        }
        return message;
    }
}
