package com.xunyi.beast.data.message;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

/**
 * 错误信息
 */
@ToString
@Getter
@Setter
public class XYError implements IError {

    private String code;

    @Nullable
    private Object[] args;

    public XYError(@NonNull String code) {
        this.code = code;
    }

    public XYError(@NonNull String code, @Nullable Object[] args) {
        this.code = code;
        this.args = args;
    }

    public boolean is(String errorCode) {
        return this.code.equalsIgnoreCase(errorCode);
    }
}
