/*
 * Decompiled with CFR 0.152.
 */
package com.xunyi.beast.data.message;

import com.xunyi.beast.data.message.IError;
import com.xunyi.beast.data.message.XYError;
import java.util.Locale;
import org.springframework.context.MessageSource;

public class ErrorMessageSource {
    public MessageSource messageSource;

    public ErrorMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    private String convertMessageCode(String type) {
        return type.toLowerCase().replace("_", ".");
    }

    public String getMessage(IError error) {
        String errorCode = error.getCode();
        Object[] args = null;
        if (error instanceof XYError) {
            args = ((XYError)error).getArgs();
        }
        return this.getMessage(errorCode, args);
    }

    public String getMessage(String errorCode, Object ... args) {
        String messageCode = this.convertMessageCode(errorCode);
        String message = null;
        try {
            message = this.messageSource.getMessage(messageCode, args, Locale.CHINA);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (message == null) {
            message = errorCode;
        }
        return message;
    }
}

