package com.xunyi.beast.data.redis.repository;

import com.xunyi.beast.data.redis.serializer.InstantRedisSerializer;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.data.repository.NoRepositoryBean;

import java.time.Instant;


@NoRepositoryBean
public abstract class AbstractNonceTokenRepository extends RedisTemplate<String, Instant> {

    private StringRedisSerializer keySerializer = new StringRedisSerializer();
    private InstantRedisSerializer valueSerializer = new InstantRedisSerializer();
    public static final String PREFIX = "once:";
    private String app;

    public AbstractNonceTokenRepository(String app, RedisConnectionFactory connectionFactory) {
        this.app = app;
        this.setConnectionFactory(connectionFactory);
    }


    protected String ofKey(String group, String once) {
        return PREFIX + this.app + ":" + group + ":" + once;
    }
    public boolean add(String group, String once, long seconds) {
        String key = ofKey(group, once);
        Boolean result = this.execute(connection -> {
            final byte[] rawKey = this.keySerializer.serialize(key);
            final byte[] rawValue = this.valueSerializer.serialize(Instant.now());
            assert rawKey != null;
            assert rawValue != null;

            return connection.set(rawKey, rawValue, Expiration.seconds(seconds), RedisStringCommands.SetOption.SET_IF_ABSENT);
        }, true, false);
        return result != null && result;
    }
}
