package com.xunyi.beast.data.money.jackson.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.JsonTokenId;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.xunyi.beast.data.money.SimpleMoney;

import java.io.IOException;
import java.math.BigDecimal;

public class SimpleMoneyDeserializer extends StdScalarDeserializer<SimpleMoney> {

    protected final SimpleMoney empty = null;
    public SimpleMoneyDeserializer() {
        super(SimpleMoney.class);
    }

    @Override
    public SimpleMoney deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (p.hasToken(JsonToken.VALUE_NUMBER_FLOAT)) {
            return SimpleMoney.of(p.getFloatValue());
        }
        if (p.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            return SimpleMoney.of(p.getIntValue());
        }
        switch (p.getCurrentTokenId()) {
            case JsonTokenId.ID_STRING:
                String text = p.getText().trim();
                if (text.length() == 0) {
                    return empty;
                }
                return SimpleMoney.of(new BigDecimal(p.getText()));
            case JsonTokenId.ID_NULL:
                return empty;
            default:
                break;
        }

        return (SimpleMoney) ctxt.handleUnexpectedToken(_valueClass, p);
    }
}
