package com.xunyi.beast.data.message.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.xunyi.beast.data.message.ErrorInfo;
import com.xunyi.beast.data.message.XYError;
import org.springframework.context.MessageSource;

import java.io.IOException;
import java.util.Locale;

public class MessageModule extends SimpleModule {

    private MessageSource messageSource;

    public MessageModule(MessageSource messageSource) {
        super(Version.unknownVersion());
        this.messageSource = messageSource;
        this.addSerializer(XYError.class, new ErrorSerializer());
    }

    public class ErrorSerializer extends StdScalarSerializer<XYError> {

        private ErrorSerializer() {
            super(XYError.class);
        }

        private String convertMessageCode(String type) {
            return type.toLowerCase().replace("_", ".");
        }
        @Override
        public void serialize(XYError error, JsonGenerator gen, SerializerProvider provider) throws IOException {
            String errorCode = error.getCode();
            Object[] args = error.getArgs();
            String messageCode = convertMessageCode(errorCode);
            String message = null;
            try {
                message = messageSource.getMessage(messageCode, args, Locale.CHINA);
            } catch (Exception ignore) {
            }
            if (message == null) {
                message = errorCode;
            }
            gen.writeObject(new ErrorInfo(errorCode, message));
        }
    }
}
