package com.xunyi.beast.data.message;

/*
 * web passport
 * 通用错误代码
 * 错误代码范围  10000 < CODE < 110000
 */
public enum StandardErrors implements IErrorOwner {

    //服务不可达
    SERVICE_UNAVAILABLE(),

    //服务繁忙
    SERVICE_BUSY(),

    //未知错误
    UNKNOWN_ERROR(),

    //参数错误
    PARAMETER_BAD(),

    //未经授权
    UNAUTHORIZED(),

    //禁止403
    FORBIDDEN(),

    //HTTP级别错误 accept不可处理
    HTTP_MEDIA_TYPE_NOT_ACCEPTABLE,
    //HTTP级别错误 请求方法不支持
    HTTP_REQUEST_METHOD_NOT_SUPPORTED,

    XYTOKEN_INVALID,
    ;
    private String errorCode;

    StandardErrors() {
        this.errorCode = this.name();
    }

    public static StandardErrors valueOfMessage(String message) {
        try {
            return StandardErrors.valueOf(message);
        } catch (Exception e) {
            return UNKNOWN_ERROR;
        }
    }

    @Override
    public String getErrorCode() {
        return this.errorCode;
    }

}
