package com.xunyi.beast.data.message;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.springframework.lang.NonNull;


/**
 * 将错误信息 扩展
 */
@ToString
@Getter @Setter
public class ErrorInfo implements IError {


    private String code;

    private String message;

    public ErrorInfo() {
        //反序列化需要
    }

    public ErrorInfo(@NonNull String code) {
        this.code = code;
    }

    public ErrorInfo(@NonNull String code, String message) {
        this(code);
        this.message = message;
    }

    public boolean is(String errorCode) {
        return this.code.equalsIgnoreCase(errorCode);
    }



}
