package com.xunyi.beast.core.support;

import java.time.temporal.Temporal;

public class ShortcutFieldResolver {

    public ShortcutField resolve(String name, Class clazz) {
        ShortcutField.Type type;
        if (Number.class.isAssignableFrom(clazz)) {
            type = ShortcutField.Type.NUMBER;
        } else
        if (Temporal.class.isAssignableFrom(clazz)) {
            type = ShortcutField.Type.DATETIME;
        } else
        if (CharSequence.class.isAssignableFrom(clazz)) {
            type = ShortcutField.Type.STRING;
        } else {
            type = ShortcutField.Type.UNKNOWN;
        }
        return ShortcutField.of(name, type);
    }

}
