package com.xunyi.beast.core.support;

import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.Expression;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;

import java.util.Map;

public class ConfigurationUtils {

    public static void bind(Object o, Map<String, Object> properties, String configurationPropertyName, String bindingName, Validator validator) {
        Object toBind = getTargetObject(o);

        new Binder(new MapConfigurationPropertySource(properties))
                .bind(configurationPropertyName, Bindable.ofInstance(toBind));
        if (validator != null) {
            BindingResult errors = new BeanPropertyBindingResult(toBind, bindingName);
            validator.validate(toBind, errors);
            if (errors.hasErrors()) {
                throw new RuntimeException(new BindException(errors));
            }
        }

    }

    public static <T> T getTargetObject(Object candidate) {
        if (AopUtils.isAopProxy(candidate) && candidate instanceof Advised) {
            try {
                return (T) ((Advised) candidate).getTargetSource().getTarget();
            } catch (Exception e) {
                throw new IllegalStateException("Failed to unwrap proxied object", e);
            }
        }
        return (T) candidate;
    }


    public static Object getValue(SpelExpressionParser parser, BeanResolver resolver, String entryValue) {
        Object value;
        if (entryValue != null && entryValue.startsWith("#{") && entryValue.endsWith("}")) {
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.setBeanResolver(resolver);
            Expression expression = parser.parseExpression(entryValue, new TemplateParserContext());
            value = expression.getValue();
        } else {
            value = entryValue;
        }
        return value;
    }
}
