package com.xunyi.beast.core.support;

import lombok.Getter;
import org.springframework.beans.BeanUtils;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;

import java.util.List;
import java.util.function.Supplier;

public class AbstractConfigurable<C> implements Configurable<C> {

    @Getter
    private Class<C> configClass;

    protected AbstractConfigurable(Class<C> configClass) {
        this.configClass = configClass;
    }

    protected AbstractConfigurable() {
        Class<?> configurableImpl = this.getClass();
        List<TypeInformation<?>> arguments = ClassTypeInformation.from(configurableImpl)
                .getRequiredSuperTypeInformation(AbstractConfigurable.class)
                .getTypeArguments();
        this.configClass = resolveTypeParameter(arguments, 0, () -> String.format("could not resolve domain type of %s!", configurableImpl));
    }

    private Class<C> resolveTypeParameter(List<TypeInformation<?>> arguments, int index, Supplier<String> exceptionMessage) {
        if (arguments.size() <= index || arguments.get(index) == null) {
            throw new IllegalArgumentException(exceptionMessage.get());
        }
        return (Class<C>) arguments.get(index).getType();
    }

    @Override
    public C newConfig() {
        return BeanUtils.instantiateClass(this.configClass);
    }
}
