/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.youxi.auth.game.service;

import com.xunlei.youxi.auth.game.entry.GameLoginReq;
import com.xunlei.youxi.auth.game.entry.GameLoginResp;
import com.xunlei.youxi.auth.game.exception.AuthGameParameterException;
import com.xunlei.youxi.auth.game.exception.AuthGameProcessException;
import com.xunlei.youxi.auth.game.exception.AuthGameVerifyException;
import com.xunlei.youxi.auth.game.service.GameLogin000066;
import com.xunlei.youxi.auth.game.service.GameLoginCopartner;
import com.xunlei.youxi.auth.game.service.GameLoginPwd;
import com.xunlei.youxi.auth.game.service.GameLoginService;
import com.xunlei.youxi.auth.game.service.WebGameKey;
import org.apache.log4j.Logger;

public class WebGameLicense {
    protected static Logger logger = Logger.getLogger(WebGameLicense.class);
    public static final String PwdSign = "0000";
    public static final String UseridSign = "0002";
    public static final String AdvidSign = "0005";
    public static final String TouristSign = "1004";
    protected static GameLoginService copartner = new GameLoginCopartner();
    protected static GameLoginService pwd = new GameLoginPwd();
    protected static GameLoginService huapi2 = new GameLogin000066();

    public static GameLoginResp verify(GameLoginReq req) throws AuthGameParameterException, AuthGameProcessException, AuthGameVerifyException {
        return WebGameLicense.verify(req, WebGameKey.instance.getPublicKey(req.getGameid()), WebGameKey.instance.getPrivateKey(req.getGameid()));
    }

    public static GameLoginResp verify(GameLoginReq req, byte[] publicKey, byte[] privateKey) throws AuthGameParameterException, AuthGameProcessException, AuthGameVerifyException {
        GameLoginResp resp = huapi2.verify(req, publicKey, privateKey);
        if (resp != null) {
            return resp;
        }
        resp = pwd.verify(req, publicKey, privateKey);
        if (resp != null) {
            return resp;
        }
        resp = copartner.verify(req, publicKey, privateKey);
        return resp;
    }
}

